### Live Video Cloud API

This folder contains the definition of the public Live Video Cloud API.

Subfolders are used to categorize different services.

* **[account](./account)**: Connected account functionality (Facebook, Twitch et al)
* **[auditlog](./auditlog)**: Audit log events
* **[auth/token](./auth/token)**: Login and logout
* **[input](./input)**: Management of inputs
* **[input/source](./input/source)**: Sources of inputs
* **[input/stream](./input/stream)**: Streams as they appear on inputs
* **[internal](./internal)**: Internal API calls that may change without notice
* **[longrunning](./longrunning)**: Process monitoring for long running operations
* **[output](./output)**: Management of outputs and transcodings
* **[output/target](./output/target)**: Individual target destinations
* **[production](./production)**: Management of productions
* **[rbac](./rbac)**: Role-based access control settings
* **[serviceregion](./serviceregion)**: Query for regions in which LVC operates
* **[team](./team)**: Team and member management
* **[transfer](./transfer)**: File transfer services (includes on-demand trimming)
* **[transfertarget](./transfertarget)**: Transfer target management
* **[type](./type)**: Common types
* **[usage](./usage)**: Usage and billing
* **[user](./user)**: User management and account creation
* **[videoasset](./videoasset)**: Video asset management and search

**Note**: API clients require a client token to perform API calls. Please contact support to receive an API token.

### Authorization

API clients must exchange a user and password for a bearer token using the [TokenService](./auth/token/token_service.proto)
and provide a valid `Authorization` header.

The following pseudo-code shows how to generate the `Authorization` header:

``` 
client_id = '080214d6-d4dd-4cc5-b07a-e0a0459c130f.foo.bar'
client_secret = 'secret'
auth_header = 'Basic ' + base64(urlEncode(client_id) + ':' + urlEncode(client_secret))
```

Following requests must include the `access_token` response in the `Authorization` header.

``` 
access_token = 'response from TokenService.CreateToken' 
auth_header = 'Bearer ' + access_token
```

### Metadata

In order to aid with debugging the following metadata can be used. 

* **request_id**: Unique identifier for a request (example: set this for each individual request)
* **conversation_id**: Unique identifier for a logical group of requests (example: set this when making multiple requests while saving an entity to group the entire process)
* **session_id**: Unique identifier for an entire session (example: set this when a user opens a browser tab)

### RESTful API

The API definitions expose RESTful variants as well. If you're unfamiliar with the gRPC
syntax you can also look at the always up-to-date OpenAPI definitions at
https://api.livevideocloud.com/v1/docs/swagger.json
